<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'usuario_id',
        'empresa_id',
        'login_time',
        'logout_time',
        'session_duration',
        'ip',
        'user_agent',
        'features_used'
    ];

    protected $casts = [
        'login_time' => 'datetime',
        'logout_time' => 'datetime',
    ];

    public function usuario()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }

    // Calcula a duração da sessão em segundos
    public function calcularDuracao()
    {
        if ($this->login_time && $this->logout_time) {
            $this->session_duration = $this->logout_time->diffInSeconds($this->login_time);
            return $this->session_duration;
        }
        return null;
    }
}
