<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pedido extends Model
{
    use HasFactory;

    protected $fillable = [
        'empresa_id',
        'mesa_comanda_id',
        'status',
        'valor_total',
        'abertura',
        'fechamento',
    ];

    public function mesaComanda()
    {
        return $this->belongsTo(MesaComanda::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function itens()
    {
        return $this->hasMany(PedidoItem::class);
    }

    public function countItens(){
        return sizeof($this->itens);
    }

    public function sumTotal(){
        $total = 0;
        foreach($this->itens as $i){
            $total += $i->sub_total;
        }

        $this->total = $total;
        $this->save();
    }
}
