<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Revenda;
use App\Models\Cidade;

class RevendaController extends Controller
{
    public function index(Request $request)
    {
        $data = Revenda::when(!empty($request->nome), function ($q) use ($request) {
                return $q->where('nome', 'LIKE', "%$request->nome%");
            })
            ->when(!empty($request->cpf_cnpj), function ($q) use ($request) {
                return $q->where('cpf_cnpj', 'LIKE', "%$request->cpf_cnpj%");
            })
            ->paginate(env("PAGINACAO"));
        
        return view('revendas.index', compact('data'));
    }
    
    public function create()
    {
        $cidades = Cidade::orderBy('nome')->get();
        return view('revendas.create', compact('cidades'));
    }
    
    public function store(Request $request)
    {
        $this->validate($request, [
            'nome' => 'required',
        ], [
            'nome.required' => 'O campo nome é obrigatório'
        ]);
        
        try {
            Revenda::create($request->all());
            session()->flash("flash_success", "Revenda cadastrada com sucesso!");
        } catch (\Exception $e) {
            session()->flash("flash_error", "Erro ao cadastrar revenda: " . $e->getMessage());
        }
        
        return redirect()->route('revendas.index');
    }
    
    public function edit($id)
    {
        $item = Revenda::findOrFail($id);
        $cidades = Cidade::orderBy('nome')->get();
        return view('revendas.edit', compact('item', 'cidades'));
    }
    
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'nome' => 'required',
        ], [
            'nome.required' => 'O campo nome é obrigatório'
        ]);
        
        $item = Revenda::findOrFail($id);
        
        try {
            $item->fill($request->all())->save();
            session()->flash("flash_success", "Revenda atualizada com sucesso!");
        } catch (\Exception $e) {
            session()->flash("flash_error", "Erro ao atualizar revenda: " . $e->getMessage());
        }
        
        return redirect()->route('revendas.index');
    }
    
    public function destroy($id)
    {
        $item = Revenda::findOrFail($id);
        
        try {
            $item->delete();
            session()->flash("flash_success", "Revenda removida com sucesso!");
        } catch (\Exception $e) {
            session()->flash("flash_error", "Erro ao remover revenda: " . $e->getMessage());
        }
        
        return redirect()->route('revendas.index');
    }
} 