# Conferência de Consolidação de Estoques

Após rodar o comando de consolidação, utilize os scripts abaixo para validar se está tudo correto:

## 1. Verificar produtos SEM variação com mais de um registro de estoque
```sql
SELECT produto_id, COUNT(*) as total_registros
FROM estoques
WHERE produto_variacao_id IS NULL
GROUP BY produto_id
HAVING total_registros > 1;
```

## 2. Verificar produtos/variações com mais de um registro de estoque
```sql
SELECT produto_id, produto_variacao_id, COUNT(*) as total_registros
FROM estoques
GROUP BY produto_id, produto_variacao_id
HAVING total_registros > 1;
```

## 3. Verificar se ainda existem registros com local_id diferente de NULL
```sql
SELECT *
FROM estoques
WHERE local_id IS NOT NULL;
```

## 4. Conferir o total de estoque por produto (sem variação)
```sql
SELECT produto_id, SUM(quantidade) as total_estoque
FROM estoques
WHERE produto_variacao_id IS NULL
GROUP BY produto_id;
```

## 5. Conferir o total de estoque por produto e variação
```sql
SELECT produto_id, produto_variacao_id, SUM(quantidade) as total_estoque
FROM estoques
GROUP BY produto_id, produto_variacao_id;
```

**Dica:**
- O resultado das consultas 1, 2 e 3 deve ser vazio (sem duplicidade nem local_id diferente de NULL).
- As consultas 4 e 5 mostram o saldo final por produto/variação. 

**Como Usar:**
## 1. No terminal, rode:
php artisan consolidar:estoques

## 3. O comando irá:
Somar todos os estoques de cada produto (e variação, se houver).
Criar/atualizar um único registro com local_id = NULL.
Excluir todos os registros duplicados com local_id <> NULL.
Mostrar um resumo ao final.

**Dica:**
Faça um backup do banco antes de rodar!
Depois, confira se cada produto ficou com apenas UM registro de estoque (local_id = NULL) e a soma está correta.