@extends('layouts.app', ['title' => 'Impressão OP - ' . ($op->numero ?? ('OP-' . str_pad($op->codigo_sequencial ?? 0, 5, '0', STR_PAD_LEFT)))])
@section('content')
<div class="container mt-3">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <img src="{{ $empresa?->img }}" alt="Logo" style="height:48px;width:auto;border-radius:4px;margin-right:10px;">
                    <div>
                        <div style="font-weight:700;font-size:16px;">{{ $empresa?->nome_fantasia ?? $empresa?->nome }}</div>
                        <div style="font-size:12px;color:#666;">CNPJ: {{ $empresa?->cpf_cnpj }} • IE: {{ $empresa?->ie }}</div>
                        <div style="font-size:12px;color:#666;">{{ $empresa?->rua }} {{ $empresa?->numero }}, {{ $empresa?->bairro }} • CEP: {{ $empresa?->cep }}</div>
                    </div>
                </div>
                <div>
                    <a class="btn btn-primary btn-sm" href="{{ route('ordem-producao.pdf', [$op->id, 'empresa_id' => $op->empresa_id]) }}"><i class="ri-file-download-line"></i> PDF</a>
                    <!-- <button class="btn btn-dark btn-sm" onclick="window.print()"><i class="ri-printer-line"></i> Imprimir</button> -->
                    <a href="{{ route('ordem-producao.index') }}" class="btn btn-secondary btn-sm">Voltar</a>
                </div>
            </div>
            <hr>
            <h4>Ordem de Produção {{ $op->numero }}</h4>
        </div>
        <div class="card-body">
            <div class="row g-2">
                <div class="col-md-3">
                    <label class="form-label">Situação</label>
                    <div><strong>{{ $op->situacao === 'finalizado' ? 'Finalizado' : 'Em Produção' }}</strong></div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Data da Produção</label>
                    <div>{{ $op->data_producao ? __data_pt($op->data_producao, 0) : '-' }}</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Previsão de Entrega</label>
                    <div>{{ $op->data_prevista_entrega ? __data_pt($op->data_prevista_entrega, 0) : '-' }}</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Cliente/Destinatário</label>
                    <div>{{ optional($op->cliente)->nome_fantasia ?? optional($op->cliente)->razao_social ?? '-' }}</div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Usuário responsável</label>
                    <div>{{ optional($op->creator)->name ?? '-' }}</div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Finalizado por</label>
                    <div>{{ optional($op->finisher)->name ?? '-' }} @if($op->finished_at) em {{ __data_pt($op->finished_at) }} @endif</div>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Observação</label>
                    <div>{{ $op->observacao }}</div>
                </div>
            </div>
            <hr>
            <h5>Itens</h5>
            <div class="table-responsive">
                <table class="table table-bordered table-sm">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 60%">Produto</th>
                            <th style="width: 10%">UN</th>
                            <th style="width: 15%" class="text-end">Quantidade</th>
                            <th style="width: 15%">Obs. Item</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php($total = 0)
                        @foreach($op->itens as $it)
                            @php($qt = (float)($it->quantidade ?? 0))
                            @php($total += $qt)
                            <tr>
                                <td>{{ optional($it->produto)->nome }}</td>
                                <td>{{ optional($it->produto)->unidade }}</td>
                                <td class="text-end">{{ number_format($qt, 2, ',', '.') }}</td>
                                <td>{{ $it->observacao }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="2" class="text-end">Total</th>
                            <th class="text-end">{{ number_format($total, 2, ',', '.') }}</th>
                            <th></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>
<style>
@media print {
    .navbar, .footer, .btn, a, .card-header a { display:none !important; }
    .card { border: none; }
}
</style>
@endsection
