<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Relatório de Produções</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background: #f0f0f0; }
        .text-end { text-align: right; }
        .mb-10 { margin-bottom: 10px; }
    </style>
</head>
<body>
    <table style="border:0; margin-bottom: 8px;">
        <tr>
            <td style="border:0; width: 70%; vertical-align: middle;">
                <div>
                    <div style="font-weight:700; font-size:16px;">{{ $empresa?->nome_fantasia ?? $empresa?->nome }}</div>
                    <div style="font-size:11px; color:#444;">CNPJ: {{ $empresa?->cpf_cnpj }} • IE: {{ $empresa?->ie }}</div>
                    <div style="font-size:11px; color:#444;">{{ $empresa?->rua }} {{ $empresa?->numero }}, {{ $empresa?->bairro }} • CEP: {{ $empresa?->cep }}</div>
                </div>
            </td>
            <td style="border:0; width: 30%; text-align: right;">
                <div style="font-size:22px; font-weight:700;">Relatório de Produções</div>
                <div style="font-size:11px; color:#555;">Gerado em: {{ __data_pt(now()) }}</div>
            </td>
        </tr>
    </table>
    <table>
        <thead>
            <tr>
                <th style="width:15%">Número</th>
                <th style="width:15%">Data produção</th>
                <th style="width:30%">Produto</th>
                <th style="width:10%">UN</th>
                <th style="width:15%" class="text-end">Quantidade</th>
                <th style="width:15%">Cliente / Situação / Usuário</th>
            </tr>
        </thead>
        <tbody>
            @php($total = 0)
            @php($currentNumero = null)
            @php($groupTotal = 0)
            @foreach($rows as $row)
                @php($total += (float)$row->quantidade)
                @php($numeroOp = 'OP-'.str_pad((string)($row->codigo_sequencial ?? 0), 5, '0', STR_PAD_LEFT))
                @if($currentNumero !== $numeroOp)
                    @if(!is_null($currentNumero))
                        <tr style="background:#f0f0f0;">
                            <td colspan="4" class="text-end"><strong>Total {{ $currentNumero }}</strong></td>
                            <td class="text-end"><strong>{{ number_format($groupTotal, 3, ',', '.') }}</strong></td>
                            <td></td>
                        </tr>
                    @endif
                    @php($currentNumero = $numeroOp)
                    @php($groupTotal = 0)
                    <tr style="background:#f7f7f7;">
                        <td colspan="2"><strong>{{ $numeroOp }}</strong> • {{ $row->data_producao ? __data_pt($row->data_producao, 0) : '' }}</td>
                        <td colspan="2"><strong>Cliente:</strong> {{ $row->cliente }}</td>
                        <td colspan="2">
                            <strong>Situação:</strong> {{ $row->situacao === 'finalizado' ? 'Finalizado' : 'Em Produção' }}
                            &nbsp;•&nbsp;
                            <strong>Usuário:</strong> {{ $row->usuario }}
                        </td>
                    </tr>
                    <tr style="background:#fcfcfc;">
                        <td></td>
                        <td></td>
                        <td><strong>Produto</strong></td>
                        <td><strong>UN</strong></td>
                        <td class="text-end"><strong>Quantidade</strong></td>
                        <td></td>
                    </tr>
                @endif
                <tr>
                    <td></td>
                    <td></td>
                    <td>{{ $row->produto }}</td>
                    <td>{{ $row->unidade }}</td>
                    <td class="text-end">{{ number_format($row->quantidade, 3, ',', '.') }}</td>
                    <td></td>
                </tr>
                @php($groupTotal += (float)$row->quantidade)
            @endforeach
            @if(!is_null($currentNumero))
                <tr style="background:#f0f0f0;">
                    <td colspan="4" class="text-end"><strong>Total {{ $currentNumero }}</strong></td>
                    <td class="text-end"><strong>{{ number_format($groupTotal, 3, ',', '.') }}</strong></td>
                    <td></td>
                </tr>
            @endif
        </tbody>
        <tfoot>
            <tr>
                <th colspan="4" class="text-end">Total</th>
                <th class="text-end">{{ number_format($total, 3, ',', '.') }}</th>
                <th></th>
            </tr>
        </tfoot>
    </table>
</body>
</html>
