@extends('layouts.app', ['title' => 'Ordens de Produção'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    @can('ordem_producao_create')
                    <a href="{{ route('ordem-producao.create') }}" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Ordem de Produção
                    </a>
                    @endcan
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->get()
                    !!}
                    <div class="row mt-3 g-2">
                        
                        <div class="col-md-2">
                            {!!Form::date('start_date', 'Data de início')
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('end_date', 'Data de início')
                            !!}
                        </div>
                        

                        <div class="col-md-3">
                            {!!Form::select('situacao', 'Situação', ['' => 'Todas', 'em_producao' => 'Em Produção', 'finalizado' => 'Finalizado'])
                            ->attrs(['class' => 'form-select'])
                            !!}
                        </div>
                        <div class="col-md-4">
                            {!!Form::select('cliente_id', 'Cliente')->options(\App\Models\Cliente::selectRaw('id, COALESCE(nome_fantasia, razao_social) as nome')->orderBy('nome')->pluck('nome','id')->prepend('Todos','')->toArray())
                            ->attrs(['class' => 'form-select'])
                            !!}
                        </div>

                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="{{ route('ordem-producao.index') }}"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                </div>
                <div class="col-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    
                                    <th>Número</th>
                                    <th>Cliente/Destinatário</th>
                                    <th>Data produção</th>
                                    <th>Previsão entrega</th>
                                    <th>Situação</th>
                                    <th>Observação</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data as $item)
                                <tr>
                                    <td>{{ $item->numero }}</td>
                                    <td>{{ optional($item->cliente)->nome_fantasia ?? optional($item->cliente)->razao_social }}</td>
                                    <td>{{ $item->data_producao ? __data_pt($item->data_producao, 0) : '' }}</td>
                                    <td>{{ $item->data_prevista_entrega ? __data_pt($item->data_prevista_entrega, 0) : '' }}</td>
                                    <td>
                                        @if($item->situacao === 'finalizado')
                                            <span class="badge bg-success">Finalizado</span>
                                        @else
                                            <span class="badge bg-warning text-dark">Em Produção</span>
                                        @endif
                                    </td>
                                    <td>{{ $item->observacao }}</td>
                                    <td>
                                        <div class="d-inline">
                                            @if($item->situacao !== 'finalizado')
                                                @can('ordem_producao_edit')
                                                <a class="btn btn-warning btn-sm op-action" href="{{ route('ordem-producao.edit', [$item->id]) }}" title="Editar" data-bs-toggle="tooltip" data-bs-placement="top">
                                                    <i class="ri-pencil-fill"></i>
                                                </a>
                                                @endcan
                                                @can('ordem_producao_delete')
                                                <form action="{{ route('ordem-producao.destroy', $item->id) }}" method="post" class="d-inline">
                                                    @method('delete')
                                                    @csrf
                                                    <button type="submit" class="btn btn-delete btn-sm btn-danger op-action" onclick="return confirm('Confirma excluir esta OP?')" title="Excluir" data-bs-toggle="tooltip" data-bs-placement="top">
                                                        <i class="ri-delete-bin-line"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                                <form action="{{ route('ordem-producao.finalizar', $item->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-success btn-sm op-action" onclick="return confirm('Confirmar finalização da OP?')" title="Finalizar" data-bs-toggle="tooltip" data-bs-placement="top">
                                                        <i class="ri-check-double-line"></i>
                                                    </button>
                                                </form>
                                            @endif
                                            <a title="Imprimir" href="{{ route('ordem-producao.imprimir', $item->id) }}" class="btn btn-info btn-sm text-white op-action" data-bs-toggle="tooltip" data-bs-placement="top">
                                                <i class="ri-printer-fill text-white"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">Nada encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                        <br>
                        
                    </div>
                </div>
                {!! $data->appends(request()->all())->links() !!}
            </div>
        </div>
</div>
@endsection
@section('js')
<style>
    /* Centraliza ícones em botões icônicos e garante dimensões consistentes */
    .op-action{
        display: inline-flex !important;
        align-items: center;
        justify-content: center;
        width: 44px;  /* largura padrao */
        height: 36px; /* mesma altura dos demais */
        padding: 0 !important;
        border-radius: 10px; /* arredondado igual aos outros */
    }
    .op-action i{ display:block; line-height: 1; font-size: 18px; margin: 0; }
    /* Badges já configuradas no HTML (bg-warning/bg-success) */
    
</style>
<script>
    document.addEventListener('DOMContentLoaded', function(){
        // Inicializar tooltips (Bootstrap 5)
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endsection
