@extends('layouts.app', ['title' => 'Teste email'])
@section('content')
<div class="mt-3">
	<div class="row">
		<div class="card">
			<div class="card-body">
				{!!Form::open()
				->post()
				->route('teste-email-send')
				!!}
				<div class="pl-lg-4">

					<div class="row g-2">

						<div class="col-md-12">
							{!!Form::textarea('texto', 'Texto')
							->attrs(['rows' => '3'])
							->required()
							!!}
						</div>

						<div class="col-md-6">
							{!!Form::text('assunto', 'Assunto')
							->required()
							!!}
						</div>

						<div class="col-md-6">
							{!!Form::text('destinatario', 'Destinatário')
							->type('email')
							->required()
							!!}
						</div>

						<div class="col-12 d-flex justify-content-end gap-3 mt-3">
							<button type="submit" class="btn btn-success px-5" id="btn-store">Enviar</button>
							<a href="{{ route('email-config.index') }}"  class="btn btn-secondary btn-sm px-3">
                            <i class="ri-arrow-left-double-fill"></i> Voltar
                        </a>
						</div>
					</div>
				</div>
				{!!Form::close()!!}
			</div>
		</div>
	</div>
</div>
{{-- SweetAlert2 para feedback de envio de e-mail --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@if(session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Sucesso!',
        text: '{{ session('success') }}',
        showConfirmButton: true,
        confirmButtonText: 'Fechar',
        allowOutsideClick: false,
        allowEscapeKey: true
    });
</script>
@endif
@if(session('error'))
<script>
    Swal.fire({
        icon: 'error',
        title: 'Erro!',
        text: '{{ session('error') }}',
        showConfirmButton: true,
        confirmButtonText: 'Fechar',
        allowOutsideClick: false,
        allowEscapeKey: true
    });
</script>
@endif
<script>
    // Esconde o alerta automaticamente após 5 segundos
    setTimeout(function() {
        var alert = document.querySelector('.alert');
        if(alert) {
            alert.classList.remove('show');
            alert.classList.add('fade');
        }
    }, 5000);
</script>
@endsection

