@extends('layouts.app', ['title' => 'Opções de Inventário'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <h4 class="mb-3">Opções de Contagem - Inventário #{{ $inventario->numero_sequencial }}</h4>
                    <p class="text-muted">
                        Selecione uma das opções abaixo para continuar com o processo de inventário.
                    </p>
                </div>
                <hr class="mt-3">
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif

                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><i class="ri-file-list-3-line text-primary me-2"></i> Imprimir Lista para Contagem Manual</h5>
                                <p class="text-muted">
                                    Gere um PDF com todos os produtos selecionados para fazer a contagem manualmente.
                                    O arquivo incluirá código, código de barras, descrição do produto e um campo para anotar a quantidade contada.
                                    <strong class="text-danger">Atenção: Esta é uma listagem para preenchimento manual durante a contagem e não um relatório final com resultados.</strong>
                                </p>
                                <div class="mt-auto">
                                    <a href="{{ route('processo-inventario.print-listagem', $inventario->id) }}" class="btn btn-outline-primary">
                                        <i class="ri-printer-line"></i> Imprimir Lista
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card bg-light h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><i class="ri-database-2-line text-success me-2"></i> Registrar Quantidades no Sistema</h5>
                                <p class="text-muted">
                                    Após realizar a contagem física, utilize esta opção para registrar as quantidades diretamente no sistema.
                                </p>
                                <div class="mt-auto">
                                    <a href="{{ route('processo-inventario.manual', $inventario->id) }}" class="btn btn-outline-success">
                                        <i class="ri-edit-box-line"></i> Registrar Quantidades
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-6">
                        <div class="card bg-light h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><i class="ri-file-excel-2-line text-warning me-2"></i> Gerar Planilha Modelo</h5>
                                <p class="text-muted">
                                    Baixe uma planilha Excel com todos os produtos selecionados para preencher as quantidades.
                                    Este modelo já contém todos os produtos e pode ser importado novamente após o preenchimento.
                                </p>
                                <div class="mt-auto">
                                    <a href="{{ route('processo-inventario.gerar-modelo', $inventario->id) }}" class="btn btn-outline-warning">
                                        <i class="ri-file-download-line"></i> Baixar Planilha
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card bg-light h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><i class="ri-upload-2-line text-info me-2"></i> Importar Planilha</h5>
                                <p class="text-muted">
                                    Após preencher a planilha modelo com as quantidades contadas, utilize esta opção para
                                    importar os dados para o sistema.
                                </p>
                                <div class="mt-auto">
                                    <a href="{{ route('processo-inventario.importacao', $inventario->id) }}" class="btn btn-outline-info">
                                        <i class="ri-upload-cloud-line"></i> Importar Planilha
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card bg-light">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><i class="ri-scales-3-line text-danger me-2"></i> Analisar Divergências e Ajustar Estoque</h5>
                                <p class="text-muted">
                                    Após registrar as quantidades contadas, utilize esta opção para comparar com o estoque atual,
                                    analisar divergências e realizar ajustes seletivos no estoque.
                                </p>
                                <div class="mt-3">
                                    <a href="{{ route('processo-inventario.comparar', $inventario->id) }}" class="btn btn-outline-danger">
                                        <i class="ri-equalizer-line"></i> Analisar e Ajustar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card bg-light">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><i class="ri-file-chart-line text-primary me-2"></i> Relatório de Inventário</h5>
                                <p class="text-muted">
                                    Gere um relatório completo em PDF com os resultados do inventário, incluindo análise de divergências, 
                                    comparativo entre estoque atual e quantidade contada, e resumo estatístico.
                                    <strong>Este relatório só mostrará resultados após a contagem dos produtos.</strong>
                                </p>
                                <div class="mt-3">
                                    <a href="{{ route('processo-inventario.print-relatorio', $inventario->id) }}" class="btn btn-outline-primary" target="_blank">
                                        <i class="ri-file-pdf-line"></i> Gerar Relatório Completo
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card border-primary">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Informações do Inventário</h5>
                                <div class="row mt-3">
                                    <div class="col-md-6">
                                        <p><strong>Referência:</strong> {{ $inventario->referencia }}</p>
                                        <p><strong>Tipo:</strong> {{ \App\Models\Inventario::tipos()[$inventario->tipo] ?? 'Não definido' }}</p>
                                        <p><strong>Status:</strong> 
                                            @if($inventario->status == 1)
                                                <span class="badge bg-success">Ativo</span>
                                            @else
                                                <span class="badge bg-secondary">Finalizado</span>
                                            @endif
                                        </p>
                                    </div>
                                    <div class="col-md-6">
                                        <p><strong>Data de Início:</strong> {{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</p>
                                        <p><strong>Data de Fim:</strong> {{ $inventario->fim ? \Carbon\Carbon::parse($inventario->fim)->format('d/m/Y') : 'Em andamento' }}</p>
                                        <p><strong>Total de Produtos:</strong> {{ $totalProdutos }}</p>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <p><strong>Observação:</strong></p>
                                    <p>{{ $inventario->observacao ?: 'Nenhuma observação registrada.' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <a href="{{ route('processo-inventario.selecionar', $inventario->id) }}" class="btn btn-outline-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar para Seleção de Produtos
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 