@extends('layouts.app', ['title' => 'Novo Inventário'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <h4 class="mb-3">Criar Novo Inventário</h4>
                    <p class="text-muted">
                        Preencha os dados abaixo para criar um novo processo de inventário.
                        Após a criação, você poderá selecionar os produtos que farão parte deste inventário.
                    </p>
                </div>
                <hr class="mt-3">
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif

                <form action="{{ route('processo-inventario.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="referencia" class="form-label">Referência <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="referencia" name="referencia" required 
                                    placeholder="Ex: Inventário Mensal Julho/2023" value="{{ old('referencia') }}">
                                <small class="text-muted">
                                    Um nome ou descrição para identificar este inventário
                                </small>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="tipo" class="form-label">Tipo de Inventário <span class="text-danger">*</span></label>
                                <select class="form-select" id="tipo" name="tipo" required>
                                    <option value="">Selecione...</option>
                                    @foreach(\App\Models\Inventario::tipos() as $key => $value)
                                        <option value="{{ $key }}" {{ old('tipo') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="usuario_id" class="form-label">Responsável</label>
                                <select class="form-select" id="usuario_id" name="usuario_id">
                                    <option value="">Selecione...</option>
                                    @foreach($usuarios as $usuario)
                                        <option value="{{ $usuario->id }}" {{ old('usuario_id') == $usuario->id ? 'selected' : (old('usuario_id') === null && $usuario->id == auth()->id() ? 'selected' : '') }}>
                                            {{ $usuario->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <small class="text-muted">Se não selecionado, o usuário atual será definido como responsável</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="inicio" class="form-label">Data de Início</label>
                                <input type="date" class="form-control" id="inicio" name="inicio" 
                                    value="{{ old('inicio') ?: date('Y-m-d') }}">
                            </div>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="fim" class="form-label">Data de Fim (estimada)</label>
                                <input type="date" class="form-control" id="fim" name="fim" 
                                    value="{{ old('fim') }}">
                                <small class="text-muted">
                                    Opcional. A data de fim será atualizada automaticamente quando o inventário for finalizado.
                                </small>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="observacao" class="form-label">Observações</label>
                                <textarea class="form-control" id="observacao" name="observacao" rows="3" 
                                    placeholder="Observações sobre este inventário...">{{ old('observacao') }}</textarea>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="ri-save-line"></i> Criar Inventário
                            </button>
                            <a href="{{ route('processo-inventario.index') }}" class="btn btn-secondary">
                                <i class="ri-arrow-left-line"></i> Cancelar
                            </a>
                        </div>
                    </div>
                </form>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="alert alert-info">
                            <h5><i class="ri-information-line"></i> Fluxo do Processo</h5>
                            <p class="mb-0">
                                Após criar o inventário, você será direcionado para a tela de seleção de produtos, onde poderá escolher quais itens 
                                farão parte deste processo. Em seguida, poderá optar por imprimir uma lista para contagem manual, registrar as
                                quantidades diretamente no sistema ou gerar uma planilha para preenchimento.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 