@extends('layouts.app', ['title' => 'Contas a Receber'])
@section('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
<style>
    .dropdown-menu {
        position: absolute !important;
        z-index: 9999 !important;
        max-height: 300px;
        overflow-y: auto;
    }
    
    .dropdown-menu-end {
        right: 0 !important;
        left: auto !important;
    }

    .table-responsive {
        min-height: 600px;
    }

    .card-body {
        padding-bottom: 80px;
    }

    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
    }

    .table th, .table td {
        vertical-align: middle;
    }

    .btn-sm {
        padding: 0.3rem 0.5rem;
        font-size: 0.75rem;
    }

    .btn-sm {
        width: 32px;
        height: 32px;
        padding: 6px;
        margin-right: 4px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Estilos para os cards de resumo */
    .resumo-card {
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s, box-shadow 0.2s;
        height: 100%;
    }
    
    .resumo-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
    }
    
    .resumo-card .card-body {
        padding: 1.25rem;
    }
    
    .resumo-card .icon-circle {
        height: 50px;
        width: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
        margin-bottom: 15px;
        color: white;
    }
    
    .resumo-card h5 {
        font-size: 1rem;
        margin-bottom: 10px;
    }
    
    .resumo-card .valor {
        font-size: 1.5rem;
        font-weight: 700;
    }
    
    .bg-receber {
        background: linear-gradient(45deg, #4e73df, #2e59d9);
    }
    
    .bg-recebido {
        background: linear-gradient(45deg, #1cc88a, #169a6f);
    }
    
    .bg-pendente {
        background: linear-gradient(45deg, #36b9cc, #2c94a3);
    }
    
    .bg-vencido {
        background: linear-gradient(45deg, #e74a3b, #be3e32);
    }
    
    .bg-parcial {
        background: linear-gradient(45deg, #f6c23e, #dda20a);
    }

    .modal .table td,
    .modal .table th {
        color: #222 !important;
        background: #fff !important;
    }
    .modal * {
        color: #222 !important;
    }
    .modal .table thead th {
        background: #f5f5f5;
        color: #333;
        font-weight: bold;
        position: sticky;
        top: 0;
        z-index: 2;
        border-bottom: 2px solid #dee2e6;
    }
    .modal .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: #f8f9fa;
    }
    .modal .table td, .modal .table th {
        vertical-align: middle;
        text-align: center;
        padding: 8px 6px;
        border-bottom: 1px solid #e9ecef;
    }
    .modal .table th {
        text-align: center;
    }
    .modal .table td:first-child, .modal .table th:first-child {
        text-align: left;
        min-width: 120px;
    }
    .modal .table td:last-child, .modal .table th:last-child {
        min-width: 80px;
    }
    .modal .alert-info {
        background: #e9f7fe;
        color: #1b4b72;
        border: 1px solid #b6e2fc;
    }
    .modal .table {
        margin-bottom: 0;
    }
</style>
@endsection
@section('content')
<style>
    .btn-sm {
        width: 32px;
        height: 32px;
        padding: 6px;
        margin-right: 4px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Estilos para os cards de resumo */
    .resumo-card {
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s, box-shadow 0.2s;
        height: 100%;
    }
    
    .resumo-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
    }
    
    .resumo-card .card-body {
        padding: 1.25rem;
    }
    
    .resumo-card .icon-circle {
        height: 50px;
        width: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
        margin-bottom: 15px;
        color: white;
    }
    
    .resumo-card h5 {
        font-size: 1rem;
        margin-bottom: 10px;
    }
    
    .resumo-card .valor {
        font-size: 1.5rem;
        font-weight: 700;
    }
    
    .bg-receber {
        background: linear-gradient(45deg, #4e73df, #2e59d9);
    }
    
    .bg-recebido {
        background: linear-gradient(45deg, #1cc88a, #169a6f);
    }
    
    .bg-pendente {
        background: linear-gradient(45deg, #36b9cc, #2c94a3);
    }
    
    .bg-vencido {
        background: linear-gradient(45deg, #e74a3b, #be3e32);
    }
    
    .bg-parcial {
        background: linear-gradient(45deg, #f6c23e, #dda20a);
    }
</style>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    @can('conta_receber_create')
                    <a href="{{ route('conta-receber.create') }}" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Conta Receber
                    </a>
                    @endcan
                </div>
                <div class="col-md-10 text-end">
                    @can('conta_receber_view')
                    <a href="{{ route('conta-receber.relatorio-inadimplencia') }}" class="btn btn-danger">
                        <i class="far fa-calendar-times"></i>
                        Relatório de Inadimplência
                    </a>
                    <a href="{{ route('conta-receber.relatorio-projecao') }}" class="btn btn-primary">
                        <i class="fas fa-chart-line"></i>
                        Fluxo de Caixa Projetado
                    </a>
                    @endcan
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->get()
                    !!}
                    <div class="row mt-3">
                        <div class="col-md-4">
                            {!!Form::select('cliente_id', 'Pesquisar por nome')->attrs(['class' => 'select2'])
                            ->options($cliente != null ? [$cliente->id => $cliente->info] : [])
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('start_date', 'Data inicial')
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('end_date', 'Data Final')
                            !!}
                        </div>
                        @if(__countLocalAtivo() > 1)
                        <div class="col-md-2">
                            {!!Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2'])
                            !!}
                        </div>
                        @endif
                        <div class="col-md-2">
                            {!!Form::select('status', 'Status', ['' => 'Todas', 1 => 'Recebidas', 0 => 'Pendentes'])
                            ->attrs(['class' => 'form-select'])
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::select('ordem', 'Ordenar por', ['' => 'Data de cadastro', 1 => 'Data de vencimento'])
                            ->attrs(['class' => 'form-select'])
                            !!}
                        </div>
                        <div class="col-md-2 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="{{ route('conta-receber.index') }}"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                </div>
                
                <!-- Cards de Resumo Financeiro -->
                <div class="row mt-4 mb-4">
                    <!-- Card Total a Receber -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-receber">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Total de Lançamentos</h5>
                                        <div class="valor">{{ __moeda(\App\Models\ContaReceber::where('empresa_id', request()->empresa_id)
                                            ->when(!empty(request('cliente_id')), function ($query) {
                                                return $query->where('cliente_id', request('cliente_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->sum('valor_integral')) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-dollar-sign text-primary"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Soma de todos os lançamentos</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Card Valor Recebido -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-recebido">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Valor Recebido</h5>
                                        <div class="valor">{{ __moeda(\App\Models\ContaReceber::where('empresa_id', request()->empresa_id)
                                            ->when(!empty(request('cliente_id')), function ($query) {
                                                return $query->where('cliente_id', request('cliente_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->sum('valor_recebido')) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-check-circle text-success"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Total já recebido</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Card Valor Pendente -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-pendente">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Valor Pendente</h5>
                                        <div class="valor">{{ __moeda(
                                            \App\Models\ContaReceber::where('empresa_id', request()->empresa_id)
                                            ->where('status', '!=', 1) // Não totalmente recebidas
                                            ->where('status', '!=', 3) // Não reparceladas
                                            ->when(!empty(request('cliente_id')), function ($query) {
                                                return $query->where('cliente_id', request('cliente_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->get()
                                            ->sum(function($conta) {
                                                return $conta->valorPendente();
                                            })
                                        ) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-clock text-info"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Total ainda a receber</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Card Valores Vencidos -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-vencido">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Valores Vencidos</h5>
                                        <div class="valor">{{ __moeda(
                                            \App\Models\ContaReceber::where('empresa_id', request()->empresa_id)
                                            ->where('status', 0) // Apenas pendentes
                                            ->whereDate('data_vencimento', '<', now()) // Vencidas
                                            ->when(!empty(request('cliente_id')), function ($query) {
                                                return $query->where('cliente_id', request('cliente_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->sum('valor_integral')
                                        ) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-exclamation-triangle text-danger"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Total de contas vencidas</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    @can('conta_receber_delete')
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    @endcan
                                    <th>Razão Social</th>
                                    @if(__countLocalAtivo() > 1)
                                    <th>Local</th>
                                    @endif
                                    <th>Valor Integral</th>
                                    <th>Valor Recebido</th>
                                    <th>Valor a Receber</th> <!-- NOVA COLUNA -->
                                    <th>Data Cadastro</th>
                                    <th>Data Vencimento</th>
                                    <th>Data Recebimento</th>
                                    <th>Estado</th>
                                    <th>Venda</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data as $item)
                                <tr class="{{ $item->status == 3 ? 'table-secondary' : ($item->status == 1 ? 'table-success' : ($item->status != 1 && strtotime($item->data_vencimento) < strtotime(date('Y-m-d')) ? 'table-danger' : '')) }}">
                                    @can('conta_receber_delete')
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="{{ $item->id }}" {{ $item->status == 3 ? 'disabled' : '' }}>
                                        </div>
                                    </td>
                                    @endcan
                                    <td>{{ ($item->cliente) ? $item->cliente->razao_social : '--' }}</td>
                                    @if(__countLocalAtivo() > 1)
                                    <td class="text-danger">{{ $item->localizacao->descricao }}</td>
                                    @endif
                                    <td>{{ __moeda($item->valor_integral) }}</td>
                                    <td>{{ __moeda($item->valor_recebido) }}</td>
                                    <td>{{ __moeda($item->valorPendente()) }}</td> <!-- NOVA CÉLULA -->
                                    <td>{{ __data_pt($item->created_at, 0) }}</td>
                                    <td>
                                        {{ __data_pt($item->data_vencimento, 0) }}
                                        @if(!$item->status)
                                        <br>
                                        <span class="text-danger" style="font-size: 10px">{{ $item->diasAtraso() }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $item->status ? __data_pt($item->data_recebimento, false) : '--' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $item->getStatusClass() }}">{{ $item->getStatusDescricao() }}</span>
                                        @if($item->parent_id)
                                        <span class="badge bg-info" title="Parcela {{ $item->parcela_atual }}/{{ $item->total_parcelas }}">
                                            <i class="ri-calendar-line"></i> Reparcelada
                                        </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->nfce)
                                        <a href="{{ route('nfce.show', [$item->nfce->id]) }}" class="btn btn-sm btn-primary">PDV</a>
                                        #{{ $item->nfce->numero_sequencial }}
                                        @elseif($item->nfe)
                                        <a href="{{ route('nfe.show', [$item->nfe->id]) }}" class="btn btn-sm btn-dark">Pedido</a>
                                        #{{ $item->nfe->numero_sequencial }}
                                        @else
                                        --
                                        @endif
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-outline-secondary btn-sm dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                Ações
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm small">

                                                @can('conta_receber_edit')
                                                    @if($item->status != 1 && $item->status != 3)
                                                    <li>
                                                        <a href="{{ route('conta-receber.pay', $item->id) }}" class="dropdown-item text-success">
                                                            <i class="ri-money-dollar-circle-line me-1"></i> Receber
                                                        </a>
                                                    </li>
                                                    @endif

                                                    @if(($item->status == 0 || $item->status == 2) && $item->status != 3)
                                                    <li>
                                                        <button type="button" class="dropdown-item text-warning" data-bs-toggle="modal" data-bs-target="#reparcelamentoModal{{ $item->id }}">
                                                            <i class="fas fa-exchange-alt me-1"></i> Reparcelar
                                                        </button>
                                                    </li>
                                                    @endif
                                                @endcan

                                                <li>
                                                    <button type="button" class="dropdown-item text-secondary" data-bs-toggle="modal" data-bs-target="#historicoModal{{ $item->id }}">
                                                        <i class="fas fa-history me-1"></i> Histórico
                                                    </button>
                                                </li>

                                                @can('conta_receber_view')
                                                    @if($item->status != 3)
                                                    <li>
                                                        <a href="{{ route('conta-receber.edit', $item->id) }}" class="dropdown-item text-primary">
                                                            <i class="ri-edit-line me-1"></i> Editar
                                                        </a>
                                                    </li>
                                                    @endif
                                                @endcan

                                                @can('boleto_create')
                                                    @if($item->status != 1 && $item->status != 3 && !$item->boleto)
                                                    <li>
                                                        <a href="{{ route('boleto.create', $item->id) }}" class="dropdown-item text-dark">
                                                            <i class="ri-bank-card-line me-1"></i> Gerar Boleto
                                                        </a>
                                                    </li>
                                                    @elseif($item->boleto)
                                                    <li>
                                                        <a href="{{ route('boleto.show', $item->boleto->id) }}" class="dropdown-item text-dark">
                                                            <i class="ri-bank-card-line me-1"></i> Ver Boleto
                                                        </a>
                                                    </li>
                                                    @endif
                                                @endcan

                                                @can('conta_receber_delete')
                                                    @if(!$item->status && $item->status != 3)
                                                    <li>
                                                        <button type="button" class="dropdown-item text-danger" onclick="confirmDeleteItem('{{ $item->id }}', '{{ __data_pt($item->data_vencimento, 0) }}, R$ {{ __moeda($item->valor_integral) }}')">
                                                            <i class="ri-delete-bin-line me-1"></i> Remover
                                                        </button>
                                                    </li>
                                                    @endif
                                                @endcan

                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">Nada encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2">Soma da pagina</td>
                                    <td>{{ __moeda($data->sum('valor_integral')) }}</td>
                                    <td>{{ __moeda($data->sum('valor_recebido')) }}</td>
                                </tr>
                            </tfoot>
                        </table>

                        <br>
                        <div class="row">
                            <div class="col-md-2">
                                @can('conta_receber_delete')
                                <form action="{{ route('conta-receber.destroy-select') }}" method="post" id="form-delete-select">
                                    @method('delete')
                                    @csrf
                                    <div></div>
                                    <button type="button" class="btn btn-danger btn-sm btn-delete-all w-100" disabled>
                                        <i class="ri-close-circle-line"></i> Remover selecionados
                                    </button>
                                </form>
                                @endcan
                            </div>

                            <div class="col-md-2">
                                @can('conta_receber_edit')
                                <form action="{{ route('conta-receber.recebe-select') }}" method="post" id="form-recebe-paga-select">
                                    @csrf
                                    <div></div>
                                    <button type="button" class="btn btn-success btn-sm w-100 btn-recebe-paga-all" disabled>
                                        <i class="ri-check-line"></i> Receber selecionados
                                    </button>
                                </form>
                                @endcan
                            </div>

                            <div class="col-md-8 text-end">
                                @can('boleto_create')
                                <form action="{{ route('boleto.create-several') }}" method="get" id="form-gerar-boletos">
                                    <div></div>
                                    <button type="submit" class="btn btn-dark px-4 py-2 btn-boleto fw-bold" disabled>
                                        <i class="ri-file-line ri-lg me-1"></i> Gerar boletos
                                    </button>
                                </form>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                {!! $data->appends(request()->all())->links() !!}
            </div>
        </div>
    </div>
</div>

@foreach($data as $item)
@if($item->status != \App\Models\ContaReceber::STATUS_RECEBIDO)
<div class="modal fade" id="recebimentoParcialModal{{ $item->id }}" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-warning text-white">
        <h5 class="modal-title">Recebimento Parcial</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <form action="{{ route('conta-receber.receber-parcial', $item->id) }}" method="POST">
        @csrf
        <div class="modal-body">
          <div class="alert alert-info">
            <p><strong>Cliente:</strong> {{ $item->cliente->razao_social ?? 'N/A' }}</p>
            <p><strong>Valor total:</strong> R$ {{ __moeda($item->valor_integral) }}</p>
            <p><strong>Valor já recebido:</strong> R$ {{ __moeda($item->valor_recebido ?? 0) }}</p>
            <p><strong>Valor pendente:</strong> R$ {{ __moeda($item->valorPendente()) }}</p>
            <p><strong>Vencimento atual:</strong> {{ __data_pt($item->data_vencimento) }}</p>
            
            @if($item->status == \App\Models\ContaReceber::STATUS_PARCIAL && $item->data_vencimento_original)
            <p><strong>Vencimento original:</strong> {{ __data_pt($item->data_vencimento_original) }}</p>
            @endif
            
            @if($item->juros_aplicados > 0 || $item->multa_aplicada > 0)
            <hr>
            <p><strong>Juros aplicados:</strong> R$ {{ __moeda($item->juros_aplicados) }}</p>
            <p><strong>Multa aplicada:</strong> R$ {{ __moeda($item->multa_aplicada) }}</p>
            @endif
          </div>
          
          <div class="form-group mb-3">
            <label for="valor_recebido_{{ $item->id }}">Valor a Receber Agora</label>
            <div class="input-group">
              <span class="input-group-text">R$</span>
              <input type="number" step="0.01" min="0.01" max="{{ $item->valorPendente() }}" 
                     class="form-control" id="valor_recebido_{{ $item->id }}" 
                     name="valor_recebido" required>
            </div>
          </div>
          
          <div class="form-group mb-3">
            <label for="tipo_pagamento_{{ $item->id }}">Forma de Pagamento</label>
            <select class="form-control" id="tipo_pagamento_{{ $item->id }}" name="tipo_pagamento" required>
              <option value="">Selecione</option>
              @foreach(App\Models\ContaReceber::tiposPagamento() as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
              @endforeach
            </select>
          </div>
          
          <div class="form-group mb-3">
            <label for="data_recebimento_{{ $item->id }}">Data do Recebimento</label>
            <input type="date" class="form-control" id="data_recebimento_{{ $item->id }}" 
                   name="data_recebimento" value="{{ date('Y-m-d') }}" required>
          </div>
          
          <div class="form-group mb-3">
            <label for="data_nova_vencimento_{{ $item->id }}">Nova Data de Vencimento</label>
            <input type="date" class="form-control" id="data_nova_vencimento_{{ $item->id }}" 
                   name="data_nova_vencimento" 
                   value="{{ date('Y-m-d', strtotime('+30 days')) }}" required>
            <small class="text-muted">Data para o próximo recebimento parcial</small>
          </div>
          
          @if($item->data_vencimento < date('Y-m-d'))
          <div class="alert alert-danger">
            <i class="fas fa-exclamation-triangle"></i> Esta conta está vencida. 
            Juros e multa serão aplicados automaticamente ao valor restante.
          </div>
          @endif
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-warning">Confirmar Recebimento Parcial</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endif
@endforeach

<!-- Modais de Reparcelamento -->
@foreach($data as $item)
@if($item->status == 0)
<div class="modal fade" id="reparcelamentoModal{{ $item->id }}" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Reparcelamento de Conta</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <form action="{{ route('conta-receber.reparcelar', $item->id) }}" method="POST">
        @csrf
        <div class="modal-body">
          <div class="alert alert-info">
            <p><strong>Cliente:</strong> {{ $item->cliente->razao_social ?? 'N/A' }}</p>
            <p><strong>Valor total:</strong> R$ {{ __moeda($item->valor_integral) }}</p>
            <p><strong>Valor pendente:</strong> R$ {{ __moeda($item->valorPendente()) }}</p>
            <p><strong>Vencimento atual:</strong> {{ __data_pt($item->data_vencimento) }}</p>
          </div>
          
          <div class="row g-2">
            <div class="col-md-4">
              <label for="total_parcelas{{ $item->id }}">Número de parcelas</label>
              <input type="number" class="form-control" id="total_parcelas{{ $item->id }}" name="total_parcelas" min="2" max="12" required>
            </div>
            
            <div class="col-md-4">
              <label for="primeira_data{{ $item->id }}">Data primeira parcela</label>
              <input type="date" class="form-control" id="primeira_data{{ $item->id }}" name="primeira_data" required>
            </div>
            
            <div class="col-md-4">
              <label for="periodicidade{{ $item->id }}">Periodicidade</label>
              <select class="form-select" id="periodicidade{{ $item->id }}" name="periodicidade" required>
                <option value="mensal">Mensal</option>
                <option value="quinzenal">Quinzenal</option>
                <option value="semanal">Semanal</option>
                <option value="diaria">Diária</option>
                <option value="bimestral">Bimestral</option>
                <option value="trimestral">Trimestral</option>
                <option value="semestral">Semestral</option>
                <option value="anual">Anual</option>
              </select>
            </div>
          </div>
          
          <div class="form-check mt-3">
            <input class="form-check-input" type="checkbox" id="juros_mora{{ $item->id }}" name="juros_mora">
            <label class="form-check-label" for="juros_mora{{ $item->id }}">
              Aplicar juros e mora sobre o valor pendente
            </label>
          </div>
        </div>
        
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary">Reparcelar Conta</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endif
@endforeach

<!-- Adicionar modais de histórico -->
@foreach($data as $item)
<!-- Modal de Histórico -->
<div class="modal fade" id="historicoModal{{ $item->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-secondary text-white">
                <h5 class="modal-title">Histórico de Movimentações</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <p><strong>Cliente:</strong> {{ $item->cliente->razao_social ?? 'N/A' }}</p>
                    <p><strong>Valor total:</strong> R$ {{ __moeda($item->valor_integral) }}</p>
                    <p><strong>Vencimento:</strong> {{ __data_pt($item->data_vencimento) }}</p>
                    <p><strong>Status atual:</strong> {{ $item->status_formatado }}</p>
                </div>
                
                <h5 class="mb-3">Movimentações:</h5>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Data</th>
                                <th>Tipo</th>
                                <th>Valor</th>
                                <th>Valor Restante</th>
                                <th>Forma de Pagamento</th>
                                <th>Data Recebimento</th>
                                <th>Vencimento</th>
                                <th>Observação</th>
                                <th>Usuário</th>
                            </tr>
                        </thead>
                        <tbody id="historico-body-{{ $item->id }}">
                            <tr>
                                <td colspan="9" class="text-center">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Carregando...</span>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
@endforeach

@endsection
@section('js')
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<script type="text/javascript" src="/js/boleto.js"></script>
<script type="text/javascript" src="/js/recebe_paga_selecionados.js"></script>

<script>
    // Carregar histórico quando o modal for aberto
    $(document).ready(function() {
        @foreach($data as $item)
        $('#historicoModal{{ $item->id }}').on('shown.bs.modal', function (e) {
            carregarHistorico({{ $item->id }});
        });
        @endforeach
        
        function carregarHistorico(contaId) {
            console.log('Chamando AJAX para conta:', contaId);
            $.ajax({
                url: "/api/conta-receber/" + contaId + "/historico",
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log('Dados recebidos:', data);
                    montarTabelaHistorico(contaId, data);
                },
                error: function(xhr, status, error) {
                    console.error('Erro na requisição:', error);
                    console.error('Status:', status);
                    console.error('Response:', xhr.responseText);
                    $('#historico-body-' + contaId).html('<tr><td colspan="9" class="text-center text-danger">Erro ao carregar histórico: ' + error + '</td></tr>');
                }
            });
        }
        
        function montarTabelaHistorico(contaId, data) {
            // Garante que sempre pega o array correto
            let historico = Array.isArray(data) ? data : (data.historico || []);
            let html = '';
            
            // Adicionar a criação da conta como primeiro registro
            html += `
                <tr>
                    <td>${formatarData(new Date())}</td>
                    <td>Criação da Conta</td>
                    <td>R$ ${formatarMoeda(data.valor_total || 0)}</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>Sistema</td>
                </tr>
            `;
            
            if (historico.length === 0) {
                html += '<tr><td colspan="9" class="text-center">Nenhum histórico adicional encontrado.</td></tr>';
            } else {
                historico.forEach(function(item) {
                    html += `
                        <tr>
                            <td>${formatarData(item.data_movimento)}</td>
                            <td>${item.tipo_movimento_formatado || item.tipo_movimento || '-'}</td>
                            <td>R$ ${formatarMoeda(item.valor)}</td>
                            <td>R$ ${formatarMoeda(item.valor_restante)}</td>
                            <td>${getTipoPagamento(item.tipo_pagamento)}</td>
                            <td>${formatarData(item.data_recebimento)}</td>
                            <td>${formatarData(item.data_vencimento)}</td>
                            <td>${item.observacao || '-'}</td>
                            <td>${item.usuario || '-'}</td>
                        </tr>
                    `;
                });
            }
            $('#historico-body-' + contaId).html(html);
        }
        
        function formatarData(dataString) {
            if (!dataString) return '-';
            let data = new Date(dataString);
            if (isNaN(data.getTime())) return '-';
            return data.toLocaleDateString('pt-BR') + ' ' + data.toLocaleTimeString('pt-BR').substring(0, 5);
        }
        
        function formatarMoeda(valor) {
            if (isNaN(valor)) return '-';
            return parseFloat(valor).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        }
        
        function getTipoPagamento(codigo) {
            const tipos = {
                '01': 'Dinheiro',
                '02': 'Cheque',
                '03': 'Cartão de Crédito',
                '04': 'Cartão de Débito',
                '05': 'Crédito Loja',
                '06': 'Crediário',
                '10': 'Vale Alimentação',
                '11': 'Vale Refeição',
                '12': 'Vale Presente',
                '13': 'Vale Combustível',
                '14': 'Duplicata Mercantil',
                '15': 'Boleto Bancário',
                '16': 'Depósito Bancário',
                '17': 'Pagamento Instantâneo (PIX)',
                '90': 'Sem Pagamento',
                '99': 'Outros'
            };
            return tipos[codigo] || codigo || '-';
        }
    });

    $(document).ready(function() {
        $('.dropdown-toggle').on('click', function() {
            var dropdown = $(this).closest('.dropdown');
            var rect = dropdown[0].getBoundingClientRect();
            var isNearBottom = window.innerHeight - rect.bottom < 150;
            if (isNearBottom) {
                dropdown.addClass('dropup');
            } else {
                dropdown.removeClass('dropup');
            }
        });
    });
</script>
@endsection
