@extends('layouts.app', ['title' => 'Visualizar Consignação'])
@section('content')

<div class="container-fluid pt-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">
                    <i class="ri-article-line me-2"></i>
                    Consignação #{{ $consignacao->numero_consignacao }}
                    <span class="badge bg-{{ $consignacao->status_color }} align-middle ms-1">{{ $consignacao->status_text }}</span>
                </h4>
                <div>
                    <a href="{{ route('consignacao.index') }}" class="btn btn-secondary">
                        <i class="ri-arrow-left-line me-1"></i>
                        Voltar
                    </a>
                    @if($consignacao->isAtiva())
                    <a href="{{ route('consignacao.devolucao', $consignacao->id) }}" class="btn btn-warning">
                        <i class="ri-arrow-go-back-line me-1"></i>
                        Devolver
                    </a>
                    <a href="{{ url('frontbox/create?consignacao_id=' . $consignacao->id) }}" class="btn btn-success" target="_blank">
                        <i class="ri-shopping-cart-2-line me-1"></i>
                        Devolver e vender o restante
                    </a>
                    @endif
                    {{-- <a href="{{ route('consignacao.imprimir', $consignacao->id) }}" class="btn btn-light" target="_blank">
                        <i class="ri-printer-line me-1"></i>
                        Imprimir
                    </a> --}}
                    
                    {{-- Implementado --}}
                    <!-- Botão com Dropdown para Impressão -->
                    <div class="btn-group">
                        <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" title="Imprimir">
                            <i class="ri-printer-line"></i>
                            Imprimir
                        </button>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="dropdown-item" href="{{ route('consignacao.imprimir', $consignacao->id) }}" target="_blank">
                                    <i class="ri-file-paper-2-line me-2"></i> Impressão A4
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="{{ route('consignacao.imprimir.termica', $consignacao->id) }}" target="_blank">
                                    <i class="ri-printer-line me-2"></i> Impressão Térmica
                                </a>
                            </li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-4">
            <div class="card h-100">
                <div class="card-header bg-light"><strong>Cliente</strong></div>
                <div class="card-body">
                    <div class="fw-semibold">{{ $consignacao->cliente->nome_fantasia ?? $consignacao->cliente->razao_social ?? 'Sem cliente' }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card h-100">
                <div class="card-header bg-light"><strong>Vendedor</strong></div>
                <div class="card-body">
                    <div class="fw-semibold">{{ $consignacao->funcionario->nome ?? '--' }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card h-100">
                <div class="card-header bg-light"><strong>Informações</strong></div>
                <div class="card-body">
                    <div><strong>Data de Vencimento:</strong> {{ $consignacao->data_vencimento ? $consignacao->data_vencimento->format('d/m/Y') : '--' }}</div>
                    <div><strong>Valor Total:</strong> <span class="fw-bold text-success">{{ __moeda($consignacao->valor_total) }}</span></div>
                    <div><strong>Observação:</strong> {{ $consignacao->observacao ?? '--' }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-3">
        <div class="card-header"><strong>Itens da Consignação</strong></div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Produto</th>
                            <th class="text-center">Qtd. Consignada</th>
                            <th class="text-center">Qtd. Vendida</th>
                            <th class="text-center">Qtd. Devolvida</th>
                            <th class="text-end">Valor Unitário</th>
                            <th class="text-end">Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($consignacao->itens as $item)
                        <tr>
                            <td>
                                <span class="fw-semibold">{{ $item->descricao }}</span>
                                <br>
                                <small class="text-muted">{{ $item->produto->codigo ?? '' }}</small>
                            </td>
                            <td class="text-center">{{ $item->quantidade }}</td>
                            <td class="text-center">{{ $item->quantidade_vendida }}</td>
                            <td class="text-center">{{ $item->quantidade_devolvida }}</td>
                            <td class="text-end">{{ __moeda($item->valor_unitario) }}</td>
                            <td class="text-end">{{ __moeda($item->sub_total) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @if($consignacao->podeSerEditada())
    <div class="card mb-3">
        <div class="card-header bg-light"><strong>Registrar Devolução</strong></div>
        <div class="card-body">
            <form action="{{ route('consignacao.devolucao', $consignacao->id) }}" method="POST">
                @csrf
                <div class="table-responsive">
                    <table class="table table-bordered align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Produto</th>
                                <th class="text-center">Qtd. Vendida</th>
                                <th class="text-center">Qtd. Devolvida</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($consignacao->itens as $item)
                            <tr>
                                <td>{{ $item->descricao }}</td>
                                <td class="text-center">{{ $item->quantidade_vendida }}</td>
                                <td class="text-center">{{ $item->quantidade_devolvida }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </form>
        </div>
    </div>
    @endif
</div>
@endsection
@section('css')
<style>
/* ESPAÇAMENTO GERAL */
.container-fluid {
    padding-top: 24px !important;
}
.card {
    background: #f7f9fa !important;
    border: 1px solid #e3e6ea !important;
    border-radius: 10px !important;
    margin-bottom: 24px !important;
    box-shadow: 0 2px 8px rgba(0,0,0,0.04) !important;
}
.card-header {
    background: #eef1f4 !important;
    border-bottom: 1px solid #e3e6ea !important;
    border-radius: 10px 10px 0 0 !important;
    padding: 12px 16px !important;
}
.card-body {
    padding: 16px !important;
    border-radius: 0 0 10px 10px !important;
}

/* TABELAS */
.table thead th, .table-light th, .table-bordered thead th {
    background: #495057 !important;
    color: #fff !important;
    font-weight: bold !important;
    font-size: 15px !important;
    border-bottom: 2px solid #343a40 !important;
    padding: 12px 8px !important;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.table tbody td {
    padding: 12px 8px !important;
    vertical-align: middle !important;
}

/* FORMULÁRIOS */
.form-label {
    font-weight: 500 !important;
    margin-bottom: 6px !important;
}

.form-control, .form-select {
    padding: 8px 12px !important;
}

/* BOTÕES */
.btn {
    padding: 8px 16px !important;
}

/* REGISTRAR DEVOLUÇÃO */
.table-bordered {
    border-color: #dee2e6 !important;
}
.table-bordered th {
    background: #e9ecef !important;
    color: #333 !important;
    font-weight: 600 !important;
}
.table-bordered td {
    background: #fff !important;
}

/* BADGES */
.badge {
    padding: 6px 10px !important;
    font-weight: 500 !important;
}
</style>
@endsection 