<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Consignação nº {{ $consignacao->numero_consignacao }}</title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 12px;
            margin: 20px;
            color: #000;
        }
        header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        header h1 {
            margin: 0;
            font-size: 18px;
            text-transform: uppercase;
        }
        .info {
            margin-bottom: 20px;
            font-size: 13px;
        }
        .info p {
            margin: 2px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 12px;
        }
        table thead {
            background: #f0f0f0;
        }
        table th, table td {
            border: 1px solid #ccc;
            padding: 6px;
        }
        table th {
            text-align: left;
        }
        table td.right {
            text-align: right;
        }
        .total {
            text-align: right;
            font-size: 14px;
            font-weight: bold;
            margin-top: 10px;
        }
        footer {
            margin-top: 40px;
            text-align: center;
            font-size: 11px;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho -->
    <header>
        <h1>Consignação</h1>
        <p><strong>Nº {{ $consignacao->numero_consignacao }}</strong></p>
        <p>{{ $consignacao->data_consignacao->format('d/m/Y H:i') }}</p>
    </header>

    <!-- Dados principais -->
    <section class="info">
        <p><strong>Cliente:</strong> {{ $consignacao->cliente->nome_fantasia ?? $consignacao->cliente->razao_social ?? '---' }}</p>
        <p><strong>Vendedor:</strong> {{ $consignacao->funcionario->nome ?? '---' }}</p>
        <p><strong>Emitido por:</strong> {{ $consignacao->usuario->name ?? '---' }}</p>
        @if($consignacao->data_vencimento)
            <p><strong>Vencimento:</strong> {{ $consignacao->data_vencimento->format('d/m/Y') }}</p>
        @endif
    </section>

    <!-- Itens -->
    <table>
        <thead>
            <tr>
                <th style="width: 40%">Produto</th>
                <th style="width: 20%" class="right">Quantidade</th>
                <th style="width: 20%" class="right">Valor Unitário</th>
                <th style="width: 20%" class="right">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($consignacao->itens as $item)
            <tr>
                <td>{{ $item->produto->nome }}</td>
                <td class="right">{{ $item->quantidade }}</td>
                <td class="right">{{ __moeda($item->valor_unitario) }}</td>
                <td class="right">{{ __moeda($item->quantidade * $item->valor_unitario) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Total -->
    <div class="total">
        Total: {{ __moeda($consignacao->valor_total) }}
    </div>

    <!-- Rodapé -->
    <footer>
        <p>DECLARO PARA OS DEVIDOS FINS QUE EFETUEI A SAIDA CONSIGNADA DAS MERCADORIAS CONSTANTES NESTE COMPROVANTE E QUE AUTORIZO A COBRANÇA POR PARTE DO ESTABELECIMENTO DESTAS MERCADORIAS, DEVIDO A NÃO DEVOLUÇÃO DAS MESMAS, OU DEVOLUÇÃO DAS MESMAS COM PROBLEMAS NÃO CONSTANTES NO MOMENTO DA RETIRADA.</p>
        <p>Documento não fiscal</p>
        <p>Obrigado pela preferência!</p>
    </footer>
</body>
</html>
