@extends('layouts.app', ['title' => 'Importação de XML'])
@section('css')
<link href="/css/custom-table-headers.css" rel="stylesheet">
<style type="text/css">
    .ri-information-line:hover{
        cursor: pointer;
    }
    
    /* Garantir que o texto do corpo da tabela seja escuro */
    .table td,
    .table-dynamic td,
    .table-produtos td {
        color: #222 !important;
    }
    /* Aplicar o mesmo padrão da tela de compras para o cabeçalho da tabela */
    /* Forçar estilo do cabeçalho para importação XML */
    .table-responsive .table thead th,
    .table-dynamic thead th,
    .table-produtos thead th,
    .table thead.table-dark th,
    .table-responsive .table thead.table-dark th,
    .table.table-dynamic.table-produtos thead th,
    .table.table-dynamic.table-produtos thead.table-dark th {
        background-color: #1a2234 !important;
        color: #ffffff !important;
        font-weight: 600 !important;
        border-color: #1a2234 !important;
    }
</style>
@endsection
@section('content')

<div class="card mt-1">
    <div class="card-header">

        <h4>Importação de XML</h4>
        @isset($dadosXml)
        <h5>Chave <strong class="text-success">{{ $dadosXml['chave'] }}</strong></h5>
        @endif
        <div style="text-align: right; margin-top: -35px;">
            @if(__countLocalAtivo() > 1 && isset($caixa))
            <h5 class="mt-2">Local: <strong class="text-danger">{{ $caixa->localizacao ? $caixa->localizacao->descricao : '' }}</strong></h5>
            @endif
            <a href="{{ route('compras.index') }}" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
    </div>
    <div class="card-body">
        {!!Form::open()
        ->post()
        ->route('compras.finish-xml')
        ->multipart()
        !!}

        <div class="pl-lg-4">
            @include('compras._forms_xml')
        </div>
        {!!Form::close()!!}
    </div>
</div>

@include('modals._altera_produto_xml')
@include('modals._modal_show_xml')

<!-- Modal para vincular produto existente -->
<div class="modal fade" id="modal_vincular_produto" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Vincular Produto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <p>Produto do XML: <strong id="produto_xml_nome"></strong></p>
                        <p>Selecione um produto existente para vincular:</p>
                        <select class="form-control select-produto-vincular"></select>
                        <input type="hidden" id="linha_atual">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success btn-confirmar-vinculo">Confirmar Vinculação</button>
            </div>
        </div>
    </div>
</div>

@section('js')
<script src="/js/nfe.js"></script>
<script src="/js/import_xml.js"></script>
@endsection
@endsection
