<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionFinanceiroConfigSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Criar a permissão se não existir
        $permission = Permission::firstOrCreate(['name' => 'financeiro_config']);
        
        // Associar a permissão ao papel de Administrador
        $adminRole = Role::where('name', 'Admin')->first();
        if ($adminRole) {
            $adminRole->givePermissionTo($permission);
        }
        
        // Associar a permissão ao papel de Financeiro (se existir)
        $financeiroRole = Role::where('name', 'Financeiro')->first();
        if ($financeiroRole) {
            $financeiroRole->givePermissionTo($permission);
        }
        
        // Associar a permissão ao papel de Gerente (se existir)
        $gerenteRole = Role::where('name', 'Gerente')->first();
        if ($gerenteRole) {
            $gerenteRole->givePermissionTo($permission);
        }
        
        $this->command->info('Permissão financeiro_config criada e associada aos papéis Admin, Financeiro e Gerente.');
    }
}
