<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class MasterUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Criar usuário master (dono do SaaS)
        $user = User::updateOrCreate(
            ['email' => 'valtenci@icloud'],
            [
                'name' => 'Administrador Master',
                'email' => 'valtenci@icloud.com',
                'password' => Hash::make('Valtenci1@'),
                'admin' => 1,
                'suporte' => 1,
            ]
        );

        // Atribuir papel de gestor_plataforma ao usuário master
        $role = Role::where('name', 'gestor_plataforma')->first();
        if ($role) {
            $user->assignRole($role);
        }

        $this->command->info('Usuário Master criado com sucesso!');
    }
}