<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('devolucoes', function (Blueprint $table) {
            if (!Schema::hasColumn('devolucoes', 'tipo_pagamento')) {
                $table->string('tipo_pagamento', 20)->nullable()->after('tipo_venda');
            }
            if (!Schema::hasColumn('devolucoes', 'data_devolucao')) {
                $table->dateTime('data_devolucao')->nullable()->after('observacoes');
            }
            // O schema original possui 'observacoes' (plural). O código usa 'observacao' (singular).
            // Para compatibilizar sem quebrar nada antigo, adicionamos 'observacao' também.
            if (!Schema::hasColumn('devolucoes', 'observacao')) {
                $table->text('observacao')->nullable()->after('tipo_pagamento');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('devolucoes', function (Blueprint $table) {
            if (Schema::hasColumn('devolucoes', 'tipo_pagamento')) {
                $table->dropColumn('tipo_pagamento');
            }
            if (Schema::hasColumn('devolucoes', 'data_devolucao')) {
                $table->dropColumn('data_devolucao');
            }
            if (Schema::hasColumn('devolucoes', 'observacao')) {
                $table->dropColumn('observacao');
            }
        });
    }
};
