<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('itens_devolucao')) {
            Schema::create('itens_devolucao', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('devolucao_id');
                $table->unsignedBigInteger('item_id');
                $table->string('tipo_item', 20); // 'item_nfe' | 'item_nfce'
                $table->decimal('quantidade', 10, 3)->default(0);
                $table->decimal('valor_unitario', 15, 2)->default(0);
                $table->unsignedBigInteger('produto_id')->nullable();
                $table->unsignedBigInteger('variacao_id')->nullable();
                $table->timestamps();

                $table->index(['devolucao_id']);
                $table->index(['item_id', 'tipo_item']);
                $table->index(['produto_id']);

                // Chaves estrangeiras opcionais (descomente se as tabelas existirem)
                // $table->foreign('devolucao_id')->references('id')->on('devolucoes')->onDelete('cascade');
                // $table->foreign('produto_id')->references('id')->on('produtos')->onDelete('set null');
                // $table->foreign('variacao_id')->references('id')->on('variacao_produtos')->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('itens_devolucao');
    }
};
