<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('item_ordem_producaos', function (Blueprint $table) {
            // Tornar item_producao_id opcional para permitir itens manuais
            if (Schema::hasColumn('item_ordem_producaos', 'item_producao_id')) {
                // Alguns bancos requerem dropar a FK antes de alterar
                try { $table->dropForeign(['item_producao_id']); } catch (\Throwable $e) {}
            }
        });
        // Alterar para nullable (requer doctrine/dbal). Se não disponível, considerar SQL bruto.
        try {
            Schema::table('item_ordem_producaos', function (Blueprint $table) {
                $table->unsignedBigInteger('item_producao_id')->nullable()->change();
            });
        } catch (\Throwable $e) {
            try {
                \DB::statement('ALTER TABLE item_ordem_producaos MODIFY item_producao_id BIGINT UNSIGNED NULL');
            } catch (\Throwable $e2) {
                // silencioso
            }
        }
        Schema::table('item_ordem_producaos', function (Blueprint $table) {
            try { $table->foreign('item_producao_id')->references('id')->on('item_producaos'); } catch (\Throwable $e) {}
        });
    }

    public function down(): void
    {
        // Reverter para not null (manterá erro se existirem nulos)
        Schema::table('item_ordem_producaos', function (Blueprint $table) {
            try { $table->dropForeign(['item_producao_id']); } catch (\Throwable $e) {}
        });
        try {
            Schema::table('item_ordem_producaos', function (Blueprint $table) {
                $table->unsignedBigInteger('item_producao_id')->nullable(false)->change();
            });
        } catch (\Throwable $e) {
            try { \DB::statement('ALTER TABLE item_ordem_producaos MODIFY item_producao_id BIGINT UNSIGNED NOT NULL'); } catch (\Throwable $e2) {}
        }
        Schema::table('item_ordem_producaos', function (Blueprint $table) {
            try { $table->foreign('item_producao_id')->references('id')->on('item_producaos'); } catch (\Throwable $e) {}
        });
    }
};
