<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('movimentacao_produtos', function (Blueprint $table) {
            if (!Schema::hasColumn('movimentacao_produtos', 'local_id')) {
                $table->integer('local_id')->nullable()->after('estoque_atual');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('movimentacao_produtos', function (Blueprint $table) {
            if (Schema::hasColumn('movimentacao_produtos', 'local_id')) {
                $table->dropColumn('local_id');
            }
        });
    }
};
