<?php

namespace App\Services;

class CupomNaoFiscalPosprint
{
    /**
     * Gera dados no formato posprint (texto ESC/POS) para impressão térmica.
     * Caso a biblioteca posprint não esteja disponível, retorna null para permitir fallback.
     */
    public function buildEscPos($venda, $config, $isPreVenda = 0, $troca = null)
    {
        if (!class_exists('NFePHP\\PosPrint\\Printer')) {
            return null;
        }

        // Montar recibo simples com dados essenciais
        $empresaNome = $config->nome ?? $config->razao_social ?? 'Empresa';
        $cpfCnpj = $config->cpf_cnpj ?? '';
        $end1 = trim(($config->logradouro ?? '') . ' ' . ($config->numero ?? ''));
        $end2 = trim(($config->bairro ?? ''));
        $cidUf = trim(($config->cidade ?? '') . ' - ' . ($config->uf ?? ''));

        $linhas = [];
        $linhas[] = [ 'text' => $empresaNome, 'align' => 'CENTER', 'emphasized' => true ];
        if ($cpfCnpj) $linhas[] = [ 'text' => $cpfCnpj, 'align' => 'CENTER' ];
        if ($end1) $linhas[] = [ 'text' => $end1, 'align' => 'CENTER' ];
        if ($end2) $linhas[] = [ 'text' => $end2, 'align' => 'CENTER' ];
        if ($cidUf) $linhas[] = [ 'text' => $cidUf, 'align' => 'CENTER' ];
        $linhas[] = [ 'text' => str_repeat('-', 32), 'align' => 'CENTER' ];
        $linhas[] = [ 'text' => 'CUPOM ' . ($isPreVenda ? 'PRÉ-VENDA' : 'NÃO FISCAL'), 'align' => 'CENTER', 'emphasized' => true ];

        // Itens
        $total = 0;
        if (!empty($venda->itens)) {
            foreach ($venda->itens as $i) {
                $nome = $i->produto->nome ?? $i->descricao ?? 'Item';
                $q = (float)($i->quantidade ?? 0);
                $vu = (float)($i->valor_unitario ?? 0);
                $st = (float)($i->sub_total ?? ($q * $vu));
                $total += $st;
                $linhas[] = [ 'text' => $nome, 'align' => 'LEFT' ];
                $linhas[] = [ 'text' => number_format($q,2,',','.') . ' x ' . number_format($vu,2,',','.') . '  ' . number_format($st,2,',','.'), 'align' => 'RIGHT' ];
            }
        }

        $desconto = (float)($venda->desconto ?? 0);
        $acrescimo = (float)($venda->acrescimo ?? 0);
        $totalGeral = (float)($venda->total ?? ($total - $desconto + $acrescimo));

        $linhas[] = [ 'text' => str_repeat('-', 32), 'align' => 'CENTER' ];
        $linhas[] = [ 'text' => 'Subtotal: ' . number_format($total,2,',','.'), 'align' => 'RIGHT' ];
        if ($desconto > 0) $linhas[] = [ 'text' => 'Desconto: -' . number_format($desconto,2,',','.'), 'align' => 'RIGHT' ];
        if ($acrescimo > 0) $linhas[] = [ 'text' => 'Acréscimo: +' . number_format($acrescimo,2,',','.'), 'align' => 'RIGHT' ];
        $linhas[] = [ 'text' => 'Total: ' . number_format($totalGeral,2,',','.'), 'align' => 'RIGHT', 'emphasized' => true ];

        if (!empty($venda->fatura) && count($venda->fatura) > 0) {
            $linhas[] = [ 'text' => str_repeat('-', 32), 'align' => 'CENTER' ];
            $linhas[] = [ 'text' => 'Pagamentos', 'align' => 'LEFT', 'emphasized' => true ];
            foreach ($venda->fatura as $f) {
                $linhas[] = [ 'text' => ($f->tipo_pagamento ?? '') . ' ' . number_format((float)($f->valor ?? 0),2,',','.'), 'align' => 'LEFT' ];
            }
        }

        if (isset($venda->troco) && (float)$venda->troco > 0) {
            $linhas[] = [ 'text' => 'Troco: ' . number_format((float)$venda->troco,2,',','.'), 'align' => 'RIGHT' ];
        }

        $linhas[] = [ 'text' => str_repeat('-', 32), 'align' => 'CENTER' ];
        $linhas[] = [ 'text' => 'Obrigado pela preferência!', 'align' => 'CENTER' ];

        // Gerar ESC/POS via biblioteca
        $printer = new \NFePHP\PosPrint\Printer();
        $printer->setJustification('LEFT');
        $printer->setFont('A');
        $printer->setAutoFeed(true);

        foreach ($linhas as $l) {
            if (!empty($l['emphasized'])) $printer->setEmphasis(true);
            if (!empty($l['align'])) $printer->setJustification($l['align']);
            $printer->text(($l['text'] ?? '') . "\n");
            if (!empty($l['emphasized'])) $printer->setEmphasis(false);
        }

        $printer->feed(3);
        return $printer->getBuffer();
    }
}


