<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FaturaContaReceber extends Model
{
    use HasFactory;
    
    /**
     * Define o nome da tabela explicitamente
     */
    protected $table = 'fatura_contas_recebers';
    
    protected $fillable = [
        'conta_receber_id',
        'empresa_id',
        'tipo_pagamento',
        'valor',
        'data_vencimento',
        'obs'
    ];
    
    protected $casts = [
        'valor' => 'decimal:2',
        'data_vencimento' => 'date'
    ];
    
    /**
     * Relacionamento com a conta a receber
     */
    public function contaReceber()
    {
        return $this->belongsTo(ContaReceber::class, 'conta_receber_id');
    }
    
    /**
     * Relacionamento com a empresa
     */
    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }
    
    /**
     * Obtém a descrição do tipo de pagamento
     */
    public function getTipoPagamentoTextoAttribute()
    {
        $tiposPagamento = ContaReceber::tiposPagamento();
        return $tiposPagamento[$this->tipo_pagamento] ?? 'Desconhecido';
    }
}
