<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class NoCachePdvMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Continua com a requisição
        $response = $next($request);
        
        // Verifica se a rota atual é a do PDV ou API de produtos
        if ($request->is('frontbox/create') || $request->is('frontbox/create/*') || $request->is('api/produtos*')) {
            // Adiciona cabeçalhos para prevenir cache
            $response->headers->set('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0');
            $response->headers->set('Cache-Control', 'post-check=0, pre-check=0', false);
            $response->headers->set('Pragma', 'no-cache');
            $response->headers->set('Expires', 'Sun, 19 Nov 1978 05:00:00 GMT');
        }
        
        return $response;
    }
}
