<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\NPSConfiguracao;
use Illuminate\Support\Facades\Validator;

class NPSConfiguracaoController extends Controller
{
    /**
     * Construtor
     */
    public function __construct()
    {
        // Middleware para verificar acesso (somente SuperAdmin)
        $this->middleware(function ($request, $next) {
            if (!__isMaster()) {
                return redirect()->route('home')->with('error', 'Acesso negado. Apenas administradores podem acessar esta funcionalidade.');
            }
            return $next($request);
        });
    }
    
    /**
     * Exibe o formulário de configuração do NPS
     * 
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $configuracao = NPSConfiguracao::obterOuCriar();
        
        return view('nps.configuracao', compact('configuracao'));
    }
    
    /**
     * Salva as configurações do NPS
     * 
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function salvar(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ativo' => 'required|boolean',
            'data_inicio' => 'nullable|date',
            'data_fim' => 'nullable|date|after_or_equal:data_inicio',
            'dia_mes' => 'required|integer|min:1|max:31',
            'titulo' => 'required|string|max:255',
            'descricao' => 'nullable|string'
        ]);
        
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        
        // Obter configuração existente ou criar uma nova
        $configuracao = NPSConfiguracao::obterOuCriar();
        
        // Atualizar os dados
        $configuracao->update([
            'ativo' => $request->ativo,
            'data_inicio' => $request->data_inicio,
            'data_fim' => $request->data_fim,
            'dia_mes' => $request->dia_mes,
            'titulo' => $request->titulo,
            'descricao' => $request->descricao
        ]);
        
        return redirect()->route('nps.configuracao')->with('flash_success', 'Configurações da pesquisa eNPS salvas com sucesso!');
    }
}
