<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class RelatorioProducaoExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    private array $filters;
    private int $empresaId;

    public function __construct(array $filters, int $empresaId)
    {
        $this->filters = $filters;
        $this->empresaId = $empresaId;
    }

    public function collection()
    {
        $q = DB::table('item_ordem_producaos as i')
            ->join('ordem_producaos as o', 'o.id', '=', 'i.ordem_producao_id')
            ->join('produtos as p', 'p.id', '=', 'i.produto_id')
            ->leftJoin('clientes as c', 'c.id', '=', 'o.cliente_id')
            ->leftJoin('users as u', 'u.id', '=', 'o.created_by')
            ->where('o.empresa_id', $this->empresaId);

        $f = $this->filters;
        if (!empty($f['start_date'])) { $q->whereDate('o.data_producao', '>=', $f['start_date']); }
        if (!empty($f['end_date'])) { $q->whereDate('o.data_producao', '<=', $f['end_date']); }
        if (!empty($f['situacao'])) { $q->where('o.situacao', $f['situacao']); }
        if (!empty($f['cliente_id'])) { $q->where('o.cliente_id', $f['cliente_id']); }
        if (!empty($f['produto_id'])) { $q->where('i.produto_id', $f['produto_id']); }

        $rows = $q->select(
            'o.codigo_sequencial', 'o.data_producao', 'p.nome as produto', 'p.unidade', 'i.quantidade', DB::raw('COALESCE(c.nome_fantasia, c.razao_social) as cliente'), 'o.situacao', 'u.name as usuario'
        )->orderBy('o.data_producao', 'desc')->orderBy('o.id', 'desc')->get();

        // Format collection as needed (e.g., map situacao and numero format)
        return $rows->map(function($r){
            return [
                'numero' => 'OP-' . str_pad((string)($r->codigo_sequencial ?? 0), 5, '0', STR_PAD_LEFT),
                'data_producao' => $r->data_producao,
                'produto' => $r->produto,
                'un' => $r->unidade,
                'quantidade' => number_format((float)$r->quantidade, 3, ',', '.'),
                'cliente' => $r->cliente,
                'situacao' => $r->situacao === 'finalizado' ? 'Finalizado' : 'Em Produção',
                'usuario' => $r->usuario,
            ];
        });
    }

    public function headings(): array
    {
        return ['Número', 'Data Produção', 'Produto', 'UN', 'Quantidade', 'Cliente', 'Situação', 'Usuário'];
    }
}
